package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 店铺名称
 * </p>
 *
 * @author ultraman
 * @since 2022-06-10
 */
public enum StoreName {

    _4463798("4463798", "抖店开放平台测试专用店"),
    _4463799("4463799", "多芬个人护理旗舰店");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StoreName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreName fromCode(String code){
        switch(code) {
            case "4463798":
                return _4463798;
            case "4463799":
                return _4463799;
            default:
                return null;
        }
    }
}
