package com.xforceplus.jcunilever.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算池
 * </p>
 *
 * @author ultraman
 * @since 2022-06-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementPool implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 结算单号
   */
  @TableField("requestNo")
  private String requestNo;

  /**
   * 订单号
   */
  @TableField("shopOrderId")
  private String shopOrderId;

  /**
   * 子订单号
   */
  @TableField("orderId")
  private String orderId;

  /**
   * 商家实收（分）
   */
  @TableField("settleAmount")
  private BigDecimal settleAmount;

  /**
   * 货款结算对应的账户类型
   */
  @TableField("payTypeDesc")
  private String payTypeDesc;

  /**
   * 结算单类型
   */
  @TableField("tradeType")
  private String tradeType;

  /**
   * 是否包含结算前退款
   */
  @TableField("isContainsRefundBeforeSettle")
  private String isContainsRefundBeforeSettle;

  /**
   * 商品ID
   */
  @TableField("productId")
  private String productId;

  /**
   * 商品数量
   */
  @TableField("goodsCount")
  private BigDecimal goodsCount;

  /**
   * 业务类型
   */
  @TableField("flowTypeDesc")
  private String flowTypeDesc;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 订单总价（分）
   */
  @TableField("totalAmount")
  private BigDecimal totalAmount;

  /**
   * 商品总价（分）
   */
  @TableField("totalGoodsAmount")
  private BigDecimal totalGoodsAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 运费（分）
   */
  @TableField("postAmount")
  private BigDecimal postAmount;

  /**
   * 店铺券（分）
   */
  @TableField("shopCoupon")
  private BigDecimal shopCoupon;

  /**
   * 结算前退款金额（分）
   */
  @TableField("refundBeforeSettle")
  private BigDecimal refundBeforeSettle;

  /**
   * 平台补贴（分）
   */
  @TableField("platformCoupon")
  private BigDecimal platformCoupon;

  /**
   * 达人补贴（分）
   */
  @TableField("authorCoupon")
  private BigDecimal authorCoupon;

  /**
   * 抖音支付补贴（分）
   */
  @TableField("ztPayPromotion")
  private BigDecimal ztPayPromotion;

  /**
   * DOU分期营销补贴（分）
   */
  @TableField("zrPayPromotion")
  private BigDecimal zrPayPromotion;

  /**
   * 用户实付（分）
   */
  @TableField("realPayAmount")
  private BigDecimal realPayAmount;

  /**
   * 收入合计（分）
   */
  @TableField("totalIncome")
  private BigDecimal totalIncome;

  /**
   * 平台服务费（分）
   */
  @TableField("platformServiceFee")
  private BigDecimal platformServiceFee;

  /**
   * 佣金（分）
   */
  private BigDecimal commission;

  /**
   * 渠道分成（分）
   */
  @TableField("goodLearnChannelFee")
  private BigDecimal goodLearnChannelFee;

  /**
   * 团长服务费（分）
   */
  @TableField("colonelServiceFee")
  private BigDecimal colonelServiceFee;

  /**
   * 直播间站外推广（分）
   */
  @TableField("channelPromotionFee")
  private BigDecimal channelPromotionFee;

  /**
   * 其他分成(学浪)（分）
   */
  @TableField("otherSharingAmount")
  private BigDecimal otherSharingAmount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 结算时间
   */
  @TableField("settleTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settleTime;

  /**
   * 下单时间
   */
  @TableField("orderTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;

  /**
   * 数据来源
   */
  @TableField("dataOrig")
  private String dataOrig;

  /**
   * 总支出(分)
   */
  @TableField("totalAutcome")
  private BigDecimal totalAutcome;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("requestNo", requestNo);
      map.put("shopOrderId", shopOrderId);
      map.put("orderId", orderId);
      map.put("settleAmount", settleAmount);
      map.put("payTypeDesc", payTypeDesc);
      map.put("tradeType", tradeType);
      map.put("isContainsRefundBeforeSettle", isContainsRefundBeforeSettle);
      map.put("productId", productId);
      map.put("goodsCount", goodsCount);
      map.put("flowTypeDesc", flowTypeDesc);
      map.put("orderType", orderType);
      map.put("totalAmount", totalAmount);
      map.put("totalGoodsAmount", totalGoodsAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("postAmount", postAmount);
      map.put("shopCoupon", shopCoupon);
      map.put("refundBeforeSettle", refundBeforeSettle);
      map.put("platformCoupon", platformCoupon);
      map.put("authorCoupon", authorCoupon);
      map.put("ztPayPromotion", ztPayPromotion);
      map.put("zrPayPromotion", zrPayPromotion);
      map.put("realPayAmount", realPayAmount);
      map.put("totalIncome", totalIncome);
      map.put("platformServiceFee", platformServiceFee);
      map.put("commission", commission);
      map.put("goodLearnChannelFee", goodLearnChannelFee);
      map.put("colonelServiceFee", colonelServiceFee);
      map.put("channelPromotionFee", channelPromotionFee);
      map.put("otherSharingAmount", otherSharingAmount);
      map.put("remark", remark);
      map.put("settleTime", BocpGenUtils.toTimestamp(settleTime));
      map.put("orderTime", BocpGenUtils.toTimestamp(orderTime));
      map.put("dataOrig", dataOrig);
      map.put("totalAutcome", totalAutcome);
      return map;
  }

  public static SettlementPool fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementPool entity = new SettlementPool();
    if(map.containsKey("requestNo")) {
      Object obj = map.get("requestNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopOrderId")) {
      Object obj = map.get("shopOrderId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShopOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAmount")) {
      Object obj = map.get("settleAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSettleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payTypeDesc")) {
      Object obj = map.get("payTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeType")) {
      Object obj = map.get("tradeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isContainsRefundBeforeSettle")) {
      Object obj = map.get("isContainsRefundBeforeSettle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsContainsRefundBeforeSettle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productId")) {
      Object obj = map.get("productId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsCount")) {
      Object obj = map.get("goodsCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setGoodsCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("flowTypeDesc")) {
      Object obj = map.get("flowTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlowTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalGoodsAmount")) {
      Object obj = map.get("totalGoodsAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postAmount")) {
      Object obj = map.get("postAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shopCoupon")) {
      Object obj = map.get("shopCoupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShopCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShopCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShopCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShopCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShopCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refundBeforeSettle")) {
      Object obj = map.get("refundBeforeSettle");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundBeforeSettle((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRefundBeforeSettle(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platformCoupon")) {
      Object obj = map.get("platformCoupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPlatformCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("authorCoupon")) {
      Object obj = map.get("authorCoupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthorCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthorCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthorCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAuthorCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthorCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ztPayPromotion")) {
      Object obj = map.get("ztPayPromotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZtPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZtPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZtPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setZtPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZtPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zrPayPromotion")) {
      Object obj = map.get("zrPayPromotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZrPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZrPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZrPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setZrPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZrPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("realPayAmount")) {
      Object obj = map.get("realPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRealPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalIncome")) {
      Object obj = map.get("totalIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platformServiceFee")) {
      Object obj = map.get("platformServiceFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPlatformServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodLearnChannelFee")) {
      Object obj = map.get("goodLearnChannelFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodLearnChannelFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setGoodLearnChannelFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("colonelServiceFee")) {
      Object obj = map.get("colonelServiceFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setColonelServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setColonelServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setColonelServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("channelPromotionFee")) {
      Object obj = map.get("channelPromotionFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChannelPromotionFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChannelPromotionFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannelPromotionFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("otherSharingAmount")) {
      Object obj = map.get("otherSharingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherSharingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOtherSharingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherSharingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleTime")) {
      Object obj = map.get("settleTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettleTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettleTime(null);
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("dataOrig")) {
      Object obj = map.get("dataOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAutcome")) {
      Object obj = map.get("totalAutcome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAutcome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAutcome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAutcome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAutcome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAutcome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
