package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
public enum FileStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "已入库"),
    _4("4", "已归档"),
    _5("5", "处理异常"),
    _6("6", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
