package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办任务主题
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
public enum TodoTaskTopic {

    RECEIVE_ORDER_CREATE("RECEIVE_ORDER_CREATE", "收货单新增待办"),
    RECEIVE_ORDER_UPDATE("RECEIVE_ORDER_UPDATE", "收货单更新待办"),
    PURCHASE_ORDER_DELETE("PURCHASE_ORDER_DELETE", "采购单删除待办"),
    RECEIVE_ORDER_DELETE("RECEIVE_ORDER_DELETE", "收货单删除待办"),
    PURCHASE_ORDER_CREATE("PURCHASE_ORDER_CREATE", "采购单新增待办"),
    PURCHASE_ORDER_UPDATE("PURCHASE_ORDER_UPDATE", "采购单更新待办"),
    EMAIL("EMAIL", "邮件待办");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TodoTaskTopic(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TodoTaskTopic fromCode(String code){
        switch(code) {
            case "RECEIVE_ORDER_CREATE":
                return RECEIVE_ORDER_CREATE;
            case "RECEIVE_ORDER_UPDATE":
                return RECEIVE_ORDER_UPDATE;
            case "PURCHASE_ORDER_DELETE":
                return PURCHASE_ORDER_DELETE;
            case "RECEIVE_ORDER_DELETE":
                return RECEIVE_ORDER_DELETE;
            case "PURCHASE_ORDER_CREATE":
                return PURCHASE_ORDER_CREATE;
            case "PURCHASE_ORDER_UPDATE":
                return PURCHASE_ORDER_UPDATE;
            case "EMAIL":
                return EMAIL;
            default:
                return null;
        }
    }
}
