package com.xforceplus.jcunilever.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMatchInit implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * billing编号
   */
  @TableField("billingDocument")
  private String billingDocument;

  /**
   * 操作者
   */
  @TableField("userName")
  private String userName;

  /**
   * G/L Account
   */
  @TableField("glAccount")
  private String glAccount;

  /**
   * 付款方编号
   */
  private String customer;

  /**
   * 分配信息
   */
  private String assignment;

  /**
   * Invoice reference
   */
  @TableField("invoiceReference")
  private String invoiceReference;

  /**
   * 关联信息
   */
  private String reference;

  /**
   * 凭证号
   */
  @TableField("documentNumber")
  private String documentNumber;

  /**
   * 凭证日期
   */
  @TableField("documentDate")
  private String documentDate;

  /**
   * Posting Date
   */
  @TableField("postingDate")
  private String postingDate;

  /**
   * Time of Entry
   */
  @TableField("timeOfEntry")
  private String timeOfEntry;

  /**
   * 付款到期日
   */
  @TableField("netDueDate")
  private String netDueDate;

  /**
   * Payment Method
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * Amount in local currency
   */
  @TableField("amountInLocalCurrency")
  private String amountInLocalCurrency;

  /**
   * 文本
   */
  private String text;

  /**
   * 凭证头文本信息
   */
  @TableField("documentHeaderText")
  private String documentHeaderText;

  /**
   * FlowType
   */
  @TableField("flowType")
  private String flowType;

  /**
   * Sp.G/L trans.type
   */
  @TableField("spGLTransType")
  private String spGLTransType;

  /**
   * 凭证类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 特殊总账标识
   */
  @TableField("specialGLInd")
  private String specialGLInd;

  /**
   * 预期天数
   */
  @TableField("arrearsAfterNetDueDate")
  private String arrearsAfterNetDueDate;

  /**
   * 销方公司编号
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * postingKey
   */
  @TableField("postingKey")
  private String postingKey;

  /**
   * 清账凭证
   */
  @TableField("clearingDocument")
  private String clearingDocument;

  /**
   * branchAccount
   */
  @TableField("branchAccount")
  private String branchAccount;

  /**
   * referenceKey3
   */
  @TableField("referenceKey3")
  private String referenceKey3;

  /**
   * paymentReference
   */
  @TableField("paymentReference")
  private String paymentReference;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billingDocument", billingDocument);
      map.put("userName", userName);
      map.put("glAccount", glAccount);
      map.put("customer", customer);
      map.put("assignment", assignment);
      map.put("invoiceReference", invoiceReference);
      map.put("reference", reference);
      map.put("documentNumber", documentNumber);
      map.put("documentDate", documentDate);
      map.put("postingDate", postingDate);
      map.put("timeOfEntry", timeOfEntry);
      map.put("netDueDate", netDueDate);
      map.put("paymentMethod", paymentMethod);
      map.put("amountInLocalCurrency", amountInLocalCurrency);
      map.put("text", text);
      map.put("documentHeaderText", documentHeaderText);
      map.put("flowType", flowType);
      map.put("spGLTransType", spGLTransType);
      map.put("documentType", documentType);
      map.put("specialGLInd", specialGLInd);
      map.put("arrearsAfterNetDueDate", arrearsAfterNetDueDate);
      map.put("companyCode", companyCode);
      map.put("postingKey", postingKey);
      map.put("clearingDocument", clearingDocument);
      map.put("branchAccount", branchAccount);
      map.put("referenceKey3", referenceKey3);
      map.put("paymentReference", paymentReference);
      return map;
  }

  public static InvoiceMatchInit fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMatchInit entity = new InvoiceMatchInit();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("glAccount")) {
      Object obj = map.get("glAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGlAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceReference")) {
      Object obj = map.get("invoiceReference");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timeOfEntry")) {
      Object obj = map.get("timeOfEntry");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTimeOfEntry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountInLocalCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowType")) {
      Object obj = map.get("flowType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialGLInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArrearsAfterNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingKey")) {
      Object obj = map.get("postingKey");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostingKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchAccount")) {
      Object obj = map.get("branchAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBranchAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey3")) {
      Object obj = map.get("referenceKey3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferenceKey3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentReference")) {
      Object obj = map.get("paymentReference");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentReference((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingDocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("glAccount")) {
      Object obj = map.get("glAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGlAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssignment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceReference")) {
      Object obj = map.get("invoiceReference");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceReference((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReference((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("timeOfEntry")) {
      Object obj = map.get("timeOfEntry");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTimeOfEntry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetDueDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountInLocalCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String) {
          this.setText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentHeaderText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowType")) {
      Object obj = map.get("flowType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpGLTransType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialGLInd")) {
      Object obj = map.get("specialGLInd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialGLInd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArrearsAfterNetDueDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postingKey")) {
      Object obj = map.get("postingKey");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostingKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClearingDocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("branchAccount")) {
      Object obj = map.get("branchAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBranchAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("referenceKey3")) {
      Object obj = map.get("referenceKey3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReferenceKey3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentReference")) {
      Object obj = map.get("paymentReference");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentReference((String)obj);
        }
      } else {
      }
    }
  }
}
