package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 异常原因
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum ErrorReasonEnum {

    BILLING_FILE_ERROR("billingFileError", "Blob-billing文件异常"),
    BILLING_DATA_CHECK_ERROR("billingDataCheckError", "billing数据校验异常"),
    BILLING_M_D_M_INFO_COMPLETION_ERROR("billingMDMInfoCompletionError", "billing数据-MDM客户信息补全异常"),
    BILLING_BUSINESS_DEPT_COMPLETION_ERROR("billingBusinessDeptCompletionError", "billing数据-业务部门补全异常"),
    BILLING_DATA_SYNC_ERROR("billingDataSyncError", "billing数据同步异常"),
    M_D_M_DATA_CHECK_ERROR("MDMDataCheckError", "MDM数据校验异常"),
    BILLINGUPLOAD_TXT_ERROR("billinguploadTxtError", "billing上传txt异常"),
    BILLINGUPLOAD_EXCEL_ERROR("billinguploadExcelError", "billing上传Excel异常"),
    PROCESS_CREATE_INVOICE_ERROR("processCreateInvoiceError", "处理新增发票异常"),
    CREATE_BILLING_INVOICE_RELATION_ERROR("createBillingInvoiceRelationError", "保存billing发票关系数据异常"),
    SYSTEM_ERROR("systemError", "系统异常"),
    OPEN_A_R_SYNC_ERROR("openARSyncError", "openAR同步单据池异常"),
    UNION_BILLING_M_D_M_INFO_COMPLETION_ERROR("unionBillingMDMInfoCompletionError", "商联-billing数据-MDM客户信息补全异常"),
    UNION_BILLING_BUSINESS_DEPT_COMPLETION_ERROR("unionBillingBusinessDeptCompletionError", "商联-billing数据-业务部门补全异常"),
    UNION_BILLING_DATA_SYNC_ERROR("unionBillingDataSyncError", "商联-billing数据同步异常"),
    BLOB_ARCHIVE_ERROR("blobArchiveError", "文件归档异常"),
    BILLING_NOT_PROCESS("billingNotProcess", "取消billing无需处理"),
    BILLING_PENDING("billingPending", "billing挂起异常"),
    OPEN_A_R_FILE_ERROR("openARFileError", "openAR文件格式不正确,非Excel文件"),
    OPEN_A_R_CHECK_ERROR("openARCheckError", "openAR校验异常"),
    CANCEL_CREATE_BILLING_INVOICE_RELATION("cancelCreateBillingInvoiceRelation", "取消创建billing关系");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErrorReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorReasonEnum fromCode(String code){
        switch(code) {
            case "billingFileError":
                return BILLING_FILE_ERROR;
            case "billingDataCheckError":
                return BILLING_DATA_CHECK_ERROR;
            case "billingMDMInfoCompletionError":
                return BILLING_M_D_M_INFO_COMPLETION_ERROR;
            case "billingBusinessDeptCompletionError":
                return BILLING_BUSINESS_DEPT_COMPLETION_ERROR;
            case "billingDataSyncError":
                return BILLING_DATA_SYNC_ERROR;
            case "MDMDataCheckError":
                return M_D_M_DATA_CHECK_ERROR;
            case "billinguploadTxtError":
                return BILLINGUPLOAD_TXT_ERROR;
            case "billinguploadExcelError":
                return BILLINGUPLOAD_EXCEL_ERROR;
            case "processCreateInvoiceError":
                return PROCESS_CREATE_INVOICE_ERROR;
            case "createBillingInvoiceRelationError":
                return CREATE_BILLING_INVOICE_RELATION_ERROR;
            case "systemError":
                return SYSTEM_ERROR;
            case "openARSyncError":
                return OPEN_A_R_SYNC_ERROR;
            case "unionBillingMDMInfoCompletionError":
                return UNION_BILLING_M_D_M_INFO_COMPLETION_ERROR;
            case "unionBillingBusinessDeptCompletionError":
                return UNION_BILLING_BUSINESS_DEPT_COMPLETION_ERROR;
            case "unionBillingDataSyncError":
                return UNION_BILLING_DATA_SYNC_ERROR;
            case "blobArchiveError":
                return BLOB_ARCHIVE_ERROR;
            case "billingNotProcess":
                return BILLING_NOT_PROCESS;
            case "billingPending":
                return BILLING_PENDING;
            case "openARFileError":
                return OPEN_A_R_FILE_ERROR;
            case "openARCheckError":
                return OPEN_A_R_CHECK_ERROR;
            case "cancelCreateBillingInvoiceRelation":
                return CANCEL_CREATE_BILLING_INVOICE_RELATION;
            default:
                return null;
        }
    }
}
