package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * discount_description
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum DiscountDescription {

    LONG_TERM_DISCOUNT("longTermDiscount", "长期折扣"),
    SHORT_TERM_DISCOUNT("shortTermDiscount", "短期折扣"),
    COVERAGE_REWARD("coverageReward", "覆盖奖励"),
    TICKET_DISCOUNT_TOTAL("ticketDiscountTotal", "票扣总额");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DiscountDescription(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiscountDescription fromCode(String code){
        switch(code) {
            case "longTermDiscount":
                return LONG_TERM_DISCOUNT;
            case "shortTermDiscount":
                return SHORT_TERM_DISCOUNT;
            case "coverageReward":
                return COVERAGE_REWARD;
            case "ticketDiscountTotal":
                return TICKET_DISCOUNT_TOTAL;
            default:
                return null;
        }
    }
}
