package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * error_reason_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum ErrorReasonEnum {

    BILLING_FILE_ERROR("billingFileError", "Blob文件获取异常"),
    BILLING_DATA_CHECK_ERROR("billingDataCheckError", "Billing数据校验异常"),
    BILLING_M_D_M_INFO_COMPLETION_ERROR("billingMDMInfoCompletionError", "Billing补全MDM异常"),
    BILLING_BUSINESS_DEPT_COMPLETION_ERROR("billingBusinessDeptCompletionError", "Billing补全业务部门异常"),
    BILLING_DATA_SYNC_ERROR("billingDataSyncError", "Billing同步单据池异常"),
    M_D_M_DATA_CHECK_ERROR("MDMDataCheckError", "MDM数据校验异常"),
    BILLINGUPLOAD_TXT_ERROR("billinguploadTxtError", "Blob上传异常TXT"),
    BILLINGUPLOAD_EXCEL_ERROR("billinguploadExcelError", "Blob上传异常Excel"),
    PROCESS_CREATE_INVOICE_ERROR("processCreateInvoiceError", "新增发票异常"),
    CREATE_BILLING_INVOICE_RELATION_ERROR("createBillingInvoiceRelationError", "Billing发票关系保存异常"),
    SYSTEM_ERROR("systemError", "系统异常"),
    OPEN_A_R_SYNC_ERROR("openARSyncError", "OpenAR同步单据池异常"),
    BLOB_ARCHIVE_ERROR("blobArchiveError", "Blob文件归档异常"),
    BILLING_NOT_PROCESS("billingNotProcess", "Billing取消处理"),
    BILLING_PENDING("billingPending", "Billing挂起异常"),
    OPEN_A_R_FILE_ERROR("openARFileError", "OpenAR文件格式错误"),
    OPEN_A_R_CHECK_ERROR("openARCheckError", "OpenAR数据校验异常"),
    CANCEL_CREATE_BILLING_INVOICE_RELATION("cancelCreateBillingInvoiceRelation", "取消创建billing关系"),
    RPA_RETURN_ERROR("rpaReturnError", "RPA处理异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErrorReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorReasonEnum fromCode(String code){
        switch(code) {
            case "billingFileError":
                return BILLING_FILE_ERROR;
            case "billingDataCheckError":
                return BILLING_DATA_CHECK_ERROR;
            case "billingMDMInfoCompletionError":
                return BILLING_M_D_M_INFO_COMPLETION_ERROR;
            case "billingBusinessDeptCompletionError":
                return BILLING_BUSINESS_DEPT_COMPLETION_ERROR;
            case "billingDataSyncError":
                return BILLING_DATA_SYNC_ERROR;
            case "MDMDataCheckError":
                return M_D_M_DATA_CHECK_ERROR;
            case "billinguploadTxtError":
                return BILLINGUPLOAD_TXT_ERROR;
            case "billinguploadExcelError":
                return BILLINGUPLOAD_EXCEL_ERROR;
            case "processCreateInvoiceError":
                return PROCESS_CREATE_INVOICE_ERROR;
            case "createBillingInvoiceRelationError":
                return CREATE_BILLING_INVOICE_RELATION_ERROR;
            case "systemError":
                return SYSTEM_ERROR;
            case "openARSyncError":
                return OPEN_A_R_SYNC_ERROR;
            case "blobArchiveError":
                return BLOB_ARCHIVE_ERROR;
            case "billingNotProcess":
                return BILLING_NOT_PROCESS;
            case "billingPending":
                return BILLING_PENDING;
            case "openARFileError":
                return OPEN_A_R_FILE_ERROR;
            case "openARCheckError":
                return OPEN_A_R_CHECK_ERROR;
            case "cancelCreateBillingInvoiceRelation":
                return CANCEL_CREATE_BILLING_INVOICE_RELATION;
            case "rpaReturnError":
                return RPA_RETURN_ERROR;
            default:
                return null;
        }
    }
}
