package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * open_a_r_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum OpenARStatusEnum {

    __1("-1", "待文件解析完成"),
    _0("0", "待处理"),
    _1("1", "已完成"),
    _2("2", "已取消"),
    _3("3", "处理异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OpenARStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OpenARStatusEnum fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
