package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * partner_fuc
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum PartnerFuc {

    SP("SP", "SP"),
    BP("BP", "BP"),
    PY("PY", "PY"),
    SH("SH", "SH"),
    ZG("ZG", "ZG");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PartnerFuc(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PartnerFuc fromCode(String code){
        switch(code) {
            case "SP":
                return SP;
            case "BP":
                return BP;
            case "PY":
                return PY;
            case "SH":
                return SH;
            case "ZG":
                return ZG;
            default:
                return null;
        }
    }
}
