package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_unit
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum BusinessUnit {

    HPC("HPC", "HPC"),
    FS("FS", "FS"),
    FR("FR", "FR"),
    IC("IC", "IC");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessUnit(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessUnit fromCode(String code){
        switch(code) {
            case "HPC":
                return HPC;
            case "FS":
                return FS;
            case "FR":
                return FR;
            case "IC":
                return IC;
            default:
                return null;
        }
    }
}
