package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * debit_credit_ind_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum DebitCreditIndEnum {

    S("S", "借方"),
    H("H", "贷方");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DebitCreditIndEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DebitCreditIndEnum fromCode(String code){
        switch(code) {
            case "S":
                return S;
            case "H":
                return H;
            default:
                return null;
        }
    }
}
