package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statement_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum StatementType {

    IC_OPEN_ITEMS("IC_OPEN_ITEMS", "IC票扣对账单 Open items"),
    IC_ALL_ITEMS("IC_ALL_ITEMS", "IC票扣对账单 All items"),
    BEGING_PERIOD_CN24("BEGING_PERIOD_CN24", "期初"),
    END_PERIOD_CN19("END_PERIOD_CN19", "期末"),
    HPC_CN08("HPC_CN08", "销售HPC"),
    IC_CN20("IC_CN20", "销售IC");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatementType fromCode(String code){
        switch(code) {
            case "IC_OPEN_ITEMS":
                return IC_OPEN_ITEMS;
            case "IC_ALL_ITEMS":
                return IC_ALL_ITEMS;
            case "BEGING_PERIOD_CN24":
                return BEGING_PERIOD_CN24;
            case "END_PERIOD_CN19":
                return END_PERIOD_CN19;
            case "HPC_CN08":
                return HPC_CN08;
            case "IC_CN20":
                return IC_CN20;
            default:
                return null;
        }
    }
}
