package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * timed_task
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum TimedTask {

    TIMED_TASK_ALL("timedTaskAll", "定时任务总开关"),
    TIMED_TASK1("timedTask1", "定时查询订单流定时任务开关"),
    TIMED_TASK2("timedTask2", "数据预处理#定时扫描Billing文件定时任务开关"),
    TIMED_TASK3("timedTask3", "数据预处理#Billing原始数据入库定时任务开关"),
    TIMED_TASK4("timedTask4", "数据预处理#Billing同步至统一单据池定时任务开关"),
    TIMED_TASK5("timedTask5", "分发消费待办定时任务开关"),
    TIMED_TASK6("timedTask6", "主数据同步#定时初始化MDM同步配置定时任务开关"),
    TIMED_TASK7("timedTask7", "主数据同步#定时获取MDM原始数据入库定时任务开关"),
    TIMED_TASK8("timedTask8", "定时消费邮件待办任务定时任务开关"),
    TIMED_TASK9("timedTask9", "生成邮件待办定时任务开关"),
    TIMED_TASK10("timedTask10", "发票回传#定时创建发票与Billing关系定时任务开关"),
    TIMED_TASK11("timedTask11", "发票回传#定时上传发票文本定时任务开关"),
    TIMED_TASK12("timedTask12", "数据预处理#定时扫描OpenAR文件定时任务开关"),
    TIMED_TASK13("timedTask13", "数据预处理#OpenAR同步至统一单据池定时任务开关"),
    TIMED_TASK14("timedTask14", "数据预处理#OpenAR原始数据入库定时任务开关"),
    TIMED_TASK15("timedTask15", "数据预处理#定时归档Blob文件定时任务开关"),
    TIMED_TASK16("timedTask16", "数据预处理#定时重试挂起的Billing定时任务开关"),
    TIMED_TASK17("timedTask17", "数据预处理#OpenAR头文件状态更新定时任务开关"),
    TIMED_TASK18("timedTask18", "MDM原始数据同步定时任务开关"),
    TIMED_TASK19("timedTask19", "结算池生成同步配置"),
    TIMED_TASK20("timedTask20", "订单结算池生成同步配置"),
    TIMED_TASK21("timedTask21", "生成折扣清单PDF定时任务开关"),
    TIMED_TASK22("timedTask22", "生成折扣清单PDF邮件定时任务开关"),
    TIMED_TASK23("timedTask23", "数据预处理#定时扫描statement文件"),
    TIMED_TASK24("timedTask24", "数据预处理#Statement原始数据入库");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TimedTask(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TimedTask fromCode(String code){
        switch(code) {
            case "timedTaskAll":
                return TIMED_TASK_ALL;
            case "timedTask1":
                return TIMED_TASK1;
            case "timedTask2":
                return TIMED_TASK2;
            case "timedTask3":
                return TIMED_TASK3;
            case "timedTask4":
                return TIMED_TASK4;
            case "timedTask5":
                return TIMED_TASK5;
            case "timedTask6":
                return TIMED_TASK6;
            case "timedTask7":
                return TIMED_TASK7;
            case "timedTask8":
                return TIMED_TASK8;
            case "timedTask9":
                return TIMED_TASK9;
            case "timedTask10":
                return TIMED_TASK10;
            case "timedTask11":
                return TIMED_TASK11;
            case "timedTask12":
                return TIMED_TASK12;
            case "timedTask13":
                return TIMED_TASK13;
            case "timedTask14":
                return TIMED_TASK14;
            case "timedTask15":
                return TIMED_TASK15;
            case "timedTask16":
                return TIMED_TASK16;
            case "timedTask17":
                return TIMED_TASK17;
            case "timedTask18":
                return TIMED_TASK18;
            case "timedTask19":
                return TIMED_TASK19;
            case "timedTask20":
                return TIMED_TASK20;
            case "timedTask21":
                return TIMED_TASK21;
            case "timedTask22":
                return TIMED_TASK22;
            case "timedTask23":
                return TIMED_TASK23;
            case "timedTask24":
                return TIMED_TASK24;
            default:
                return null;
        }
    }
}
