package com.xforceplus.jcunilever.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Customer implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 消费待办消息
   */
  @TableField("customerMessage")
  private String customerMessage;

  /**
   * 序列号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 消费待办对象
   */
  @TableField("customerObj")
  private String customerObj;

  /**
   * 消费待办状态
   */
  @TableField("customerStatus")
  private String customerStatus;

  /**
   * 消费待办类型
   */
  @TableField("customerType")
  private String customerType;

  /**
   * 消费待办来源
   */
  @TableField("customerSource")
  private String customerSource;

  /**
   * 业务流水号
   */
  @TableField("businessKey")
  private String businessKey;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 重试次数
   */
  @TableField("retryCount")
  private Long retryCount;

  /**
   * 异常信息
   */
  @TableField("errorInfo")
  private String errorInfo;

  /**
   * 重试时间
   */
  @TableField("retryTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime retryTime;

  /**
   * 异常原因
   */
  @TableField("errorReasonEnum")
  private String errorReasonEnum;


  /**
   * 对一关联关系 关联对象 producer
   */
    private Long producerToManyConsumerId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("customerMessage", customerMessage);
      map.put("serialNo", serialNo);
      map.put("customerObj", customerObj);
      map.put("customerStatus", customerStatus);
      map.put("customerType", customerType);
      map.put("customerSource", customerSource);
      map.put("businessKey", businessKey);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("retryCount", retryCount);
      map.put("errorInfo", errorInfo);
      map.put("retryTime", BocpGenUtils.toTimestamp(retryTime));
      map.put("errorReasonEnum", errorReasonEnum);

       map.put("producerToManyConsumer.id", producerToManyConsumerId);
      return map;
  }

  public static Customer fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Customer entity = new Customer();
    if(map.containsKey("customerMessage")) {
      Object obj = map.get("customerMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerObj")) {
      Object obj = map.get("customerObj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerObj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerStatus")) {
      Object obj = map.get("customerStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerSource")) {
      Object obj = map.get("customerSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessKey")) {
      Object obj = map.get("businessKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retryTime")) {
      Object obj = map.get("retryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRetryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRetryTime(null);
      }
    }
    if(map.containsKey("errorReasonEnum")) {
      Object obj = map.get("errorReasonEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorReasonEnum((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("producerToManyConsumer.id")) {
        Object obj = map.get("producerToManyConsumer.id");
      if(obj instanceof Long) {
        entity.setProducerToManyConsumerId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setProducerToManyConsumerId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("customerMessage")) {
      Object obj = map.get("customerMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerObj")) {
      Object obj = map.get("customerObj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerObj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerStatus")) {
      Object obj = map.get("customerStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerSource")) {
      Object obj = map.get("customerSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessKey")) {
      Object obj = map.get("businessKey");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retryCount")) {
      Object obj = map.get("retryCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retryTime")) {
      Object obj = map.get("retryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRetryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRetryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRetryTime(null);
      }
    }
    if(map.containsKey("errorReasonEnum")) {
      Object obj = map.get("errorReasonEnum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorReasonEnum((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("producerToManyConsumer.id")) {
        Object obj = map.get("producerToManyConsumer.id");
        if(obj instanceof Long) {
          this.setProducerToManyConsumerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProducerToManyConsumerId(Long.parseLong((String)obj));
        }
      }
  }
}
