package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * aggregate_amount_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum AggregateAmountType {

    MATERIAL_MERGE("materialMerge", "物料合并"),
    ORDER_MERGE("orderMerge", "整单合并");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AggregateAmountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AggregateAmountType fromCode(String code){
        switch(code) {
            case "materialMerge":
                return MATERIAL_MERGE;
            case "orderMerge":
                return ORDER_MERGE;
            default:
                return null;
        }
    }
}
