package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum BusinessStatus {

    _0("0", "待处理"),
    _1("1", "已创建Billing关系"),
    _4("4", "已回写合并参考号"),
    _2("2", "已上传发票文本"),
    _99("99", "处理异常"),
    _5("5", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "4":
                return _4;
            case "2":
                return _2;
            case "99":
                return _99;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
