package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_source
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum DataSource {

    SYSTEM_SYNC("systemSync", "系统同步"),
    MANUAL_IMPORT("manualImport", "手工导入");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code){
        switch(code) {
            case "systemSync":
                return SYSTEM_SYNC;
            case "manualImport":
                return MANUAL_IMPORT;
            default:
                return null;
        }
    }
}
