package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * file_format
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum FileFormat {

    XML("XML", "Billing"),
    EXCEL("Excel", "Other");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileFormat fromCode(String code){
        switch(code) {
            case "XML":
                return XML;
            case "Excel":
                return EXCEL;
            default:
                return null;
        }
    }
}
