package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * file_process_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum FileProcessEnum {

    TXT("txt", "txt"),
    EXCEL("excel", "excel");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileProcessEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileProcessEnum fromCode(String code){
        switch(code) {
            case "txt":
                return TXT;
            case "excel":
                return EXCEL;
            default:
                return null;
        }
    }
}
