package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * flow_type_desc
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum FlowTypeDesc {

    _0("0", "鲁班广告"),
    _1("1", "值点商城"),
    _2("2", "精选联盟"),
    _3("3", "小店自卖");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FlowTypeDesc(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowTypeDesc fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
