package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * p_billing_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum PBillingType {

    NORMAL("NORMAL", "正常"),
    ADJUSTED("ADJUSTED", "调整"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲"),
    OTHERS("OTHERS", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PBillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PBillingType fromCode(String code){
        switch(code) {
            case "NORMAL":
                return NORMAL;
            case "ADJUSTED":
                return ADJUSTED;
            case "WRITE_OFF":
                return WRITE_OFF;
            case "CANCEL_WRITE_OFF":
                return CANCEL_WRITE_OFF;
            case "OTHERS":
                return OTHERS;
            default:
                return null;
        }
    }
}
