package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statement_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum StatementType {

    IC_OPEN_ITEMS("IC_OPEN_ITEMS", "IC票扣对账单 Open items"),
    IC_ALL_ITEMS("IC_ALL_ITEMS", "IC票扣对账单 All items"),
    BEGING_PERIOD("BEGING_PERIOD", "期初"),
    END_PERIOD("END_PERIOD", "期末"),
    HPC("HPC", "销售HPC"),
    IC("IC", "销售IC");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatementType fromCode(String code){
        switch(code) {
            case "IC_OPEN_ITEMS":
                return IC_OPEN_ITEMS;
            case "IC_ALL_ITEMS":
                return IC_ALL_ITEMS;
            case "BEGING_PERIOD":
                return BEGING_PERIOD;
            case "END_PERIOD":
                return END_PERIOD;
            case "HPC":
                return HPC;
            case "IC":
                return IC;
            default:
                return null;
        }
    }
}
