package com.xforceplus.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * subscriber_name
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum SubscriberName {

    PURCHASE_ORDER_CREATE("PURCHASE_ORDER_CREATE", "采购单新增订阅"),
    PURCHASE_ORDER_UPDATE("PURCHASE_ORDER_UPDATE", "采购单修改订阅"),
    EMAIL("EMAIL", "邮件订阅");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubscriberName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubscriberName fromCode(String code){
        switch(code) {
            case "PURCHASE_ORDER_CREATE":
                return PURCHASE_ORDER_CREATE;
            case "PURCHASE_ORDER_UPDATE":
                return PURCHASE_ORDER_UPDATE;
            case "EMAIL":
                return EMAIL;
            default:
                return null;
        }
    }
}
