package com.xforceplus.jcunilever.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * DTC业务
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderPoolRaw implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请单号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * 错误原因
   */
  @TableField("errorInfo")
  private String errorInfo;

  /**
   * 店铺Id
   */
  @TableField("storeId")
  private String storeId;

  /**
   * 主订单号
   */
  @TableField("mainOrderNo")
  private String mainOrderNo;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 购方抬头
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 申请类型
   */
  @TableField("applyType")
  private String applyType;

  /**
   * 申请时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 结算状态
   */
  @TableField("settlementStatus")
  private String settlementStatus;

  /**
   * 开票状态
   */
  @TableField("makeInvoiceStatus")
  private String makeInvoiceStatus;

  /**
   * 提交开票状态
   */
  @TableField("submitInvoiceStatus")
  private String submitInvoiceStatus;

  /**
   * 发票种类
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 抬头类型
   */
  @TableField("headerType")
  private String headerType;

  /**
   * 订单总价
   */
  @TableField("orderTotal")
  private BigDecimal orderTotal;

  /**
   * 商品总价
   */
  @TableField("goodsTotal")
  private BigDecimal goodsTotal;

  /**
   * 数据来源
   */
  @TableField("dataOrig")
  private String dataOrig;

  /**
   * 结算金额
   */
  @TableField("settlementTotal")
  private BigDecimal settlementTotal;

  /**
   * 开票金额
   */
  @TableField("invoiceAmount")
  private BigDecimal invoiceAmount;

  /**
   * 开票金额与结算金额是否一致
   */
  @TableField("isConsistent")
  private String isConsistent;

  /**
   * 金额校验差额
   */
  @TableField("verificationVariance")
  private BigDecimal verificationVariance;

  /**
   * 作废时间
   */
  @TableField("cancelTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cancelTime;

  /**
   * 作废原因
   */
  @TableField("cancelReason")
  private String cancelReason;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 快递单号
   */
  @TableField("expressNumber")
  private String expressNumber;

  /**
   * 发票来源
   */
  @TableField("invoiceOrig")
  private String invoiceOrig;

  /**
   * 是否强制开票
   */
  @TableField("forceInvoice")
  private String forceInvoice;

  /**
   * 开票时间
   */
  @TableField("makeInvoiceTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime makeInvoiceTime;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 店铺名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 订单明细
   */
  @TableField("invoiceDetails")
  private String invoiceDetails;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 抖音考核倒计时
   */
  @TableField("assessmentCountDown")
  private BigDecimal assessmentCountDown;

  /**
   * 处理状态
   */
  @TableField("handleType")
  private String handleType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyNo", applyNo);
      map.put("errorInfo", errorInfo);
      map.put("storeId", storeId);
      map.put("mainOrderNo", mainOrderNo);
      map.put("businessType", businessType);
      map.put("orderType", orderType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("applyType", applyType);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("settlementStatus", settlementStatus);
      map.put("makeInvoiceStatus", makeInvoiceStatus);
      map.put("submitInvoiceStatus", submitInvoiceStatus);
      map.put("invoiceType", invoiceType);
      map.put("headerType", headerType);
      map.put("orderTotal", orderTotal);
      map.put("goodsTotal", goodsTotal);
      map.put("dataOrig", dataOrig);
      map.put("settlementTotal", settlementTotal);
      map.put("invoiceAmount", invoiceAmount);
      map.put("isConsistent", isConsistent);
      map.put("verificationVariance", verificationVariance);
      map.put("cancelTime", BocpGenUtils.toTimestamp(cancelTime));
      map.put("cancelReason", cancelReason);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("expressNumber", expressNumber);
      map.put("invoiceOrig", invoiceOrig);
      map.put("forceInvoice", forceInvoice);
      map.put("makeInvoiceTime", BocpGenUtils.toTimestamp(makeInvoiceTime));
      map.put("salesbillNo", salesbillNo);
      map.put("storeName", storeName);
      map.put("invoiceDetails", invoiceDetails);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("assessmentCountDown", assessmentCountDown);
      map.put("handleType", handleType);

      return map;
  }

  public static OrderPoolRaw fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderPoolRaw entity = new OrderPoolRaw();
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mainOrderNo")) {
      Object obj = map.get("mainOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyType")) {
      Object obj = map.get("applyType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("settlementStatus")) {
      Object obj = map.get("settlementStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeInvoiceStatus")) {
      Object obj = map.get("makeInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitInvoiceStatus")) {
      Object obj = map.get("submitInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubmitInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("headerType")) {
      Object obj = map.get("headerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHeaderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTotal")) {
      Object obj = map.get("orderTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTotal")) {
      Object obj = map.get("goodsTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("dataOrig")) {
      Object obj = map.get("dataOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementTotal")) {
      Object obj = map.get("settlementTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isConsistent")) {
      Object obj = map.get("isConsistent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsConsistent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verificationVariance")) {
      Object obj = map.get("verificationVariance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVerificationVariance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVerificationVariance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVerificationVariance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerificationVariance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerificationVariance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cancelTime")) {
      Object obj = map.get("cancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCancelTime(null);
      }
    }
    if(map.containsKey("cancelReason")) {
      Object obj = map.get("cancelReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("forceInvoice")) {
      Object obj = map.get("forceInvoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setForceInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeInvoiceTime")) {
      Object obj = map.get("makeInvoiceTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMakeInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMakeInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMakeInvoiceTime(null);
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDetails")) {
      Object obj = map.get("invoiceDetails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assessmentCountDown")) {
      Object obj = map.get("assessmentCountDown");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAssessmentCountDown((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAssessmentCountDown(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAssessmentCountDown(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAssessmentCountDown(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAssessmentCountDown(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("handleType")) {
      Object obj = map.get("handleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mainOrderNo")) {
      Object obj = map.get("mainOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyType")) {
      Object obj = map.get("applyType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("settlementStatus")) {
      Object obj = map.get("settlementStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeInvoiceStatus")) {
      Object obj = map.get("makeInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("submitInvoiceStatus")) {
      Object obj = map.get("submitInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubmitInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("headerType")) {
      Object obj = map.get("headerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHeaderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderTotal")) {
      Object obj = map.get("orderTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goodsTotal")) {
      Object obj = map.get("goodsTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("dataOrig")) {
      Object obj = map.get("dataOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementTotal")) {
      Object obj = map.get("settlementTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isConsistent")) {
      Object obj = map.get("isConsistent");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsConsistent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verificationVariance")) {
      Object obj = map.get("verificationVariance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVerificationVariance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVerificationVariance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVerificationVariance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerificationVariance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVerificationVariance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cancelTime")) {
      Object obj = map.get("cancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCancelTime(null);
      }
    }
    if(map.containsKey("cancelReason")) {
      Object obj = map.get("cancelReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expressNumber")) {
      Object obj = map.get("expressNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("forceInvoice")) {
      Object obj = map.get("forceInvoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setForceInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeInvoiceTime")) {
      Object obj = map.get("makeInvoiceTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMakeInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMakeInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMakeInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMakeInvoiceTime(null);
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceDetails")) {
      Object obj = map.get("invoiceDetails");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceDetails((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assessmentCountDown")) {
      Object obj = map.get("assessmentCountDown");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAssessmentCountDown((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAssessmentCountDown(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAssessmentCountDown(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAssessmentCountDown(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAssessmentCountDown(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("handleType")) {
      Object obj = map.get("handleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleType((String)obj);
        }
      } else {
      }
    }
  }
}
