package com.xforceplus.jcunilever.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * OTC业务
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StatementInit implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 对账单类型
   */
  @TableField("statementType")
  private String statementType;

  /**
   * 销方公司编码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 已清未清标识
   */
  @TableField("clearedOpenItemsSymbol")
  private String clearedOpenItemsSymbol;

  /**
   * 付款方编号
   */
  private String customer;

  /**
   * 凭证号
   */
  @TableField("documentNumber")
  private String documentNumber;

  /**
   * 分配
   */
  private String assignment;

  /**
   * 参照
   */
  private String reference;

  /**
   * Billing编号
   */
  @TableField("billingDocument")
  private String billingDocument;

  /**
   * 凭证类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 过账日期
   */
  @TableField("postingDate")
  private String postingDate;

  /**
   * 凭证日期
   */
  @TableField("documentDate")
  private String documentDate;

  /**
   * 净收付到期日
   */
  @TableField("netDueDate")
  private String netDueDate;

  /**
   * 逾期天数
   */
  @TableField("arrearsAfterNetDueDate")
  private String arrearsAfterNetDueDate;

  /**
   * 特殊总账标识
   */
  @TableField("specialGLIND")
  private String specialGLIND;

  /**
   * 借贷标识
   */
  @TableField("debitCreditInd")
  private String debitCreditInd;

  /**
   * 文本
   */
  private String text;

  /**
   * 凭证抬头文本
   */
  @TableField("documentHeaderText")
  private String documentHeaderText;

  /**
   * 参考关键字1
   */
  @TableField("referenceKey1")
  private String referenceKey1;

  /**
   * 对象关键字
   */
  @TableField("objectKey")
  private String objectKey;

  /**
   * 清账凭证
   */
  @TableField("clearingDocument")
  private String clearingDocument;

  /**
   * 录入日期
   */
  @TableField("entryDate")
  private String entryDate;

  /**
   * 特定总帐事务类型
   */
  @TableField("spGLTransType")
  private String spGLTransType;

  /**
   * 行项目
   */
  @TableField("lineItem")
  private String lineItem;

  /**
   * 文件名称
   */
  @TableField("fileName")
  private String fileName;

  /**
   * 处理状态
   */
  private String status;

  /**
   * 异常原因
   */
  @TableField("errorInfo")
  private String errorInfo;

  /**
   * 清账日期
   */
  @TableField("clearingDate")
  private String clearingDate;

  /**
   * 本币金额
   */
  @TableField("amountInLocalCurrency")
  private BigDecimal amountInLocalCurrency;

  /**
   * 显示货币的金额
   */
  @TableField("amountInDocCurr")
  private BigDecimal amountInDocCurr;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("statementType", statementType);
      map.put("companyCode", companyCode);
      map.put("clearedOpenItemsSymbol", clearedOpenItemsSymbol);
      map.put("customer", customer);
      map.put("documentNumber", documentNumber);
      map.put("assignment", assignment);
      map.put("reference", reference);
      map.put("billingDocument", billingDocument);
      map.put("documentType", documentType);
      map.put("postingDate", postingDate);
      map.put("documentDate", documentDate);
      map.put("netDueDate", netDueDate);
      map.put("arrearsAfterNetDueDate", arrearsAfterNetDueDate);
      map.put("specialGLIND", specialGLIND);
      map.put("debitCreditInd", debitCreditInd);
      map.put("text", text);
      map.put("documentHeaderText", documentHeaderText);
      map.put("referenceKey1", referenceKey1);
      map.put("objectKey", objectKey);
      map.put("clearingDocument", clearingDocument);
      map.put("entryDate", entryDate);
      map.put("spGLTransType", spGLTransType);
      map.put("lineItem", lineItem);
      map.put("fileName", fileName);
      map.put("status", status);
      map.put("errorInfo", errorInfo);
      map.put("clearingDate", clearingDate);
      map.put("amountInLocalCurrency", amountInLocalCurrency);
      map.put("amountInDocCurr", amountInDocCurr);

      return map;
  }

  public static StatementInit fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    StatementInit entity = new StatementInit();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementType")) {
      Object obj = map.get("statementType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearedOpenItemsSymbol")) {
      Object obj = map.get("clearedOpenItemsSymbol");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearedOpenItemsSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssignment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReference((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArrearsAfterNetDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialGLIND")) {
      Object obj = map.get("specialGLIND");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialGLIND((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debitCreditInd")) {
      Object obj = map.get("debitCreditInd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDebitCreditInd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentHeaderText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceKey1")) {
      Object obj = map.get("referenceKey1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReferenceKey1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("objectKey")) {
      Object obj = map.get("objectKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setObjectKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpGLTransType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountInLocalCurrency((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountInLocalCurrency(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountInLocalCurrency(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountInDocCurr")) {
      Object obj = map.get("amountInDocCurr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountInDocCurr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountInDocCurr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountInDocCurr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountInDocCurr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountInDocCurr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statementType")) {
      Object obj = map.get("statementType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatementType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clearedOpenItemsSymbol")) {
      Object obj = map.get("clearedOpenItemsSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClearedOpenItemsSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentNumber")) {
      Object obj = map.get("documentNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assignment")) {
      Object obj = map.get("assignment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssignment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reference")) {
      Object obj = map.get("reference");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReference((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingDocument")) {
      Object obj = map.get("billingDocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingDocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netDueDate")) {
      Object obj = map.get("netDueDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetDueDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("arrearsAfterNetDueDate")) {
      Object obj = map.get("arrearsAfterNetDueDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArrearsAfterNetDueDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialGLIND")) {
      Object obj = map.get("specialGLIND");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialGLIND((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("debitCreditInd")) {
      Object obj = map.get("debitCreditInd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDebitCreditInd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String) {
          this.setText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentHeaderText")) {
      Object obj = map.get("documentHeaderText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentHeaderText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("referenceKey1")) {
      Object obj = map.get("referenceKey1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReferenceKey1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("objectKey")) {
      Object obj = map.get("objectKey");
      if(obj != null) {
        if(obj instanceof String) {
          this.setObjectKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clearingDocument")) {
      Object obj = map.get("clearingDocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClearingDocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entryDate")) {
      Object obj = map.get("entryDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spGLTransType")) {
      Object obj = map.get("spGLTransType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpGLTransType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clearingDate")) {
      Object obj = map.get("clearingDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClearingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountInLocalCurrency")) {
      Object obj = map.get("amountInLocalCurrency");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountInLocalCurrency((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountInLocalCurrency(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountInLocalCurrency(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountInLocalCurrency(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountInLocalCurrency(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountInDocCurr")) {
      Object obj = map.get("amountInDocCurr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountInDocCurr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountInDocCurr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountInDocCurr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountInDocCurr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountInDocCurr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
