package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcunilever.entity.OrderMainSubmit;
import com.xforceplus.jcunilever.service.IOrderMainSubmitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单已提交前端控制器
 *
 * @author ultraman
 * @date 2022-05-11
 */
@RestController
public class OrderMainSubmitController {

  @Autowired
  private IOrderMainSubmitService orderMainSubmitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderMainSubmit 订单已提交
   * @return
   */
  @GetMapping("/ordermainsubmits" )
  public XfR getOrderMainSubmits(XfPage page, OrderMainSubmit orderMainSubmit) {
    return XfR.ok(orderMainSubmitServiceImpl.page(page, Wrappers.query(orderMainSubmit)));
  }

  /**
   * 通过id查询订单已提交
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordermainsubmits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderMainSubmitServiceImpl.getById(id));
  }

  /**
   * 新增订单已提交
   * @param orderMainSubmit 订单已提交
   * @return XfR
   */
  @PostMapping("/ordermainsubmits")
  public XfR save(@RequestBody OrderMainSubmit orderMainSubmit) {
     return XfR.ok(orderMainSubmitServiceImpl.save(orderMainSubmit));
  }

  /**
   * 修改-传入修改后的全部数据订单已提交
   * @param orderMainSubmit 订单已提交
   * @return XfR
   */
  @PutMapping("/ordermainsubmits/{id}")
  public XfR putUpdate(@RequestBody OrderMainSubmit orderMainSubmit,@PathVariable Long id) {
      orderMainSubmit.setId(id);
      return XfR.ok(orderMainSubmitServiceImpl.updateById(orderMainSubmit));
  }

  /**
   * 修改-传入修改的数据订单已提交
   * @param orderMainSubmit 订单已提交
   * @return XfR
   */
  @PatchMapping("/ordermainsubmits/{id}")
  public XfR patchUpdate(@RequestBody OrderMainSubmit orderMainSubmit,@PathVariable Long id) {
      OrderMainSubmit uporderMainSubmit = orderMainSubmitServiceImpl.getById(id);
      if(uporderMainSubmit != null){
        uporderMainSubmit = ObjectCopyUtils.copyProperties(orderMainSubmit,uporderMainSubmit,true);
      }
      return XfR.ok(orderMainSubmitServiceImpl.updateById(uporderMainSubmit));
  }

  /**
   * 通过id删除订单已提交
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordermainsubmits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderMainSubmitServiceImpl.removeById(id));
  }

  @PostMapping("/ordermainsubmits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_main_submit");
     params.put("request", condition);

     return XfR.ok(orderMainSubmitServiceImpl.querys(params));
  }

}
