package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcunilever.entity.OrderPool;
import com.xforceplus.jcunilever.service.IOrderPoolService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单池前端控制器
 *
 * @author ultraman
 * @date 2022-08-08
 */
@RestController
public class OrderPoolController {

  @Autowired
  private IOrderPoolService orderPoolServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderPool 订单池
   * @return
   */
  @GetMapping("/orderpools" )
  public XfR getOrderPools(XfPage page, OrderPool orderPool) {
    return XfR.ok(orderPoolServiceImpl.page(page, Wrappers.query(orderPool)));
  }

  /**
   * 通过id查询订单池
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderpools/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderPoolServiceImpl.getById(id));
  }

  /**
   * 新增订单池
   * @param orderPool 订单池
   * @return XfR
   */
  @PostMapping("/orderpools")
  public XfR save(@RequestBody OrderPool orderPool) {
     return XfR.ok(orderPoolServiceImpl.save(orderPool));
  }

  /**
   * 修改-传入修改后的全部数据订单池
   * @param orderPool 订单池
   * @return XfR
   */
  @PutMapping("/orderpools/{id}")
  public XfR putUpdate(@RequestBody OrderPool orderPool,@PathVariable Long id) {
      orderPool.setId(id);
      return XfR.ok(orderPoolServiceImpl.updateById(orderPool));
  }

  /**
   * 修改-传入修改的数据订单池
   * @param orderPool 订单池
   * @return XfR
   */
  @PatchMapping("/orderpools/{id}")
  public XfR patchUpdate(@RequestBody OrderPool orderPool,@PathVariable Long id) {
      OrderPool uporderPool = orderPoolServiceImpl.getById(id);
      if(uporderPool != null){
        uporderPool = ObjectCopyUtils.copyProperties(orderPool,uporderPool,true);
      }
      return XfR.ok(orderPoolServiceImpl.updateById(uporderPool));
  }

  /**
   * 通过id删除订单池
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderpools/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderPoolServiceImpl.removeById(id));
  }

  @PostMapping("/orderpools/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_pool");
     params.put("request", condition);

     return XfR.ok(orderPoolServiceImpl.querys(params));
  }

}
