package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.OpenARInit;
import com.xforceplus.jcunilever.service.IOpenARInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-27
 */
@RestController
public class OpenARInitController {

  @Autowired
  private IOpenARInitService openARInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param openARInit ${table.comment}
   * @return
   */
  @GetMapping("/openarinits" )
  public XfR getOpenARInits(XfPage page, OpenARInit openARInit) {
    return XfR.ok(openARInitServiceImpl.page(page, Wrappers.query(openARInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/openarinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(openARInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param openARInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/openarinits")
  public XfR save(@RequestBody OpenARInit openARInit) {
     return XfR.ok(openARInitServiceImpl.save(openARInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param openARInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/openarinits/{id}")
  public XfR putUpdate(@RequestBody OpenARInit openARInit,@PathVariable Long id) {
      openARInit.setId(id);
      return XfR.ok(openARInitServiceImpl.updateById(openARInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param openARInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/openarinits/{id}")
  public XfR patchUpdate(@RequestBody OpenARInit openARInit,@PathVariable Long id) {
      OpenARInit upopenARInit = openARInitServiceImpl.getById(id);
      if(upopenARInit != null){
        upopenARInit = ObjectCopyUtils.copyProperties(openARInit,upopenARInit,true);
      }
      return XfR.ok(openARInitServiceImpl.updateById(upopenARInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/openarinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(openARInitServiceImpl.removeById(id));
  }

  @PostMapping("/openarinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "open_a_r_init");
     params.put("request", condition);

     return XfR.ok(openARInitServiceImpl.querys(params));
  }

}
