package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.StatementInit;
import com.xforceplus.jcunilever.service.IStatementInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-27
 */
@RestController
public class StatementInitController {

  @Autowired
  private IStatementInitService statementInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statementInit ${table.comment}
   * @return
   */
  @GetMapping("/statementinits" )
  public XfR getStatementInits(XfPage page, StatementInit statementInit) {
    return XfR.ok(statementInitServiceImpl.page(page, Wrappers.query(statementInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statementinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statementInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param statementInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/statementinits")
  public XfR save(@RequestBody StatementInit statementInit) {
     return XfR.ok(statementInitServiceImpl.save(statementInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param statementInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/statementinits/{id}")
  public XfR putUpdate(@RequestBody StatementInit statementInit,@PathVariable Long id) {
      statementInit.setId(id);
      return XfR.ok(statementInitServiceImpl.updateById(statementInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param statementInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statementinits/{id}")
  public XfR patchUpdate(@RequestBody StatementInit statementInit,@PathVariable Long id) {
      StatementInit upstatementInit = statementInitServiceImpl.getById(id);
      if(upstatementInit != null){
        upstatementInit = ObjectCopyUtils.copyProperties(statementInit,upstatementInit,true);
      }
      return XfR.ok(statementInitServiceImpl.updateById(upstatementInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statementinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statementInitServiceImpl.removeById(id));
  }

  @PostMapping("/statementinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statement_init");
     params.put("request", condition);

     return XfR.ok(statementInitServiceImpl.querys(params));
  }

}
