package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.DeliveryRuleConfig;
import com.xforceplus.jcunilever.service.IDeliveryRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-11
 */
@RestController
public class DeliveryRuleConfigController {

  @Autowired
  private IDeliveryRuleConfigService deliveryRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deliveryRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/deliveryruleconfigs" )
  public XfR getDeliveryRuleConfigs(XfPage page, DeliveryRuleConfig deliveryRuleConfig) {
    return XfR.ok(deliveryRuleConfigServiceImpl.page(page, Wrappers.query(deliveryRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deliveryruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deliveryRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deliveryRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/deliveryruleconfigs")
  public XfR save(@RequestBody DeliveryRuleConfig deliveryRuleConfig) {
     return XfR.ok(deliveryRuleConfigServiceImpl.save(deliveryRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deliveryRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/deliveryruleconfigs/{id}")
  public XfR putUpdate(@RequestBody DeliveryRuleConfig deliveryRuleConfig,@PathVariable Long id) {
      deliveryRuleConfig.setId(id);
      return XfR.ok(deliveryRuleConfigServiceImpl.updateById(deliveryRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deliveryRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deliveryruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody DeliveryRuleConfig deliveryRuleConfig,@PathVariable Long id) {
      DeliveryRuleConfig updeliveryRuleConfig = deliveryRuleConfigServiceImpl.getById(id);
      if(updeliveryRuleConfig != null){
        updeliveryRuleConfig = ObjectCopyUtils.copyProperties(deliveryRuleConfig,updeliveryRuleConfig,true);
      }
      return XfR.ok(deliveryRuleConfigServiceImpl.updateById(updeliveryRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deliveryruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deliveryRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/deliveryruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "delivery_rule_config");
     params.put("request", condition);

     return XfR.ok(deliveryRuleConfigServiceImpl.querys(params));
  }

}
