package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.TodoTask;
import com.xforceplus.jcunilever.service.ITodoTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-29
 */
@RestController
public class TodoTaskController {

  @Autowired
  private ITodoTaskService todoTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param todoTask ${table.comment}
   * @return
   */
  @GetMapping("/todotasks" )
  public XfR getTodoTasks(XfPage page, TodoTask todoTask) {
    return XfR.ok(todoTaskServiceImpl.page(page, Wrappers.query(todoTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/todotasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(todoTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param todoTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/todotasks")
  public XfR save(@RequestBody TodoTask todoTask) {
     return XfR.ok(todoTaskServiceImpl.save(todoTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param todoTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/todotasks/{id}")
  public XfR putUpdate(@RequestBody TodoTask todoTask,@PathVariable Long id) {
      todoTask.setId(id);
      return XfR.ok(todoTaskServiceImpl.updateById(todoTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param todoTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/todotasks/{id}")
  public XfR patchUpdate(@RequestBody TodoTask todoTask,@PathVariable Long id) {
      TodoTask uptodoTask = todoTaskServiceImpl.getById(id);
      if(uptodoTask != null){
        uptodoTask = ObjectCopyUtils.copyProperties(todoTask,uptodoTask,true);
      }
      return XfR.ok(todoTaskServiceImpl.updateById(uptodoTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/todotasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(todoTaskServiceImpl.removeById(id));
  }

  @PostMapping("/todotasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "todo_task");
     params.put("request", condition);

     return XfR.ok(todoTaskServiceImpl.querys(params));
  }

}
