package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.DiscountReasonConfig;
import com.xforceplus.jcunilever.service.IDiscountReasonConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-19
 */
@RestController
public class DiscountReasonConfigController {

  @Autowired
  private IDiscountReasonConfigService discountReasonConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discountReasonConfig ${table.comment}
   * @return
   */
  @GetMapping("/discountreasonconfigs" )
  public XfR getDiscountReasonConfigs(XfPage page, DiscountReasonConfig discountReasonConfig) {
    return XfR.ok(discountReasonConfigServiceImpl.page(page, Wrappers.query(discountReasonConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discountreasonconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discountReasonConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discountReasonConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/discountreasonconfigs")
  public XfR save(@RequestBody DiscountReasonConfig discountReasonConfig) {
     return XfR.ok(discountReasonConfigServiceImpl.save(discountReasonConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discountReasonConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/discountreasonconfigs/{id}")
  public XfR putUpdate(@RequestBody DiscountReasonConfig discountReasonConfig,@PathVariable Long id) {
      discountReasonConfig.setId(id);
      return XfR.ok(discountReasonConfigServiceImpl.updateById(discountReasonConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discountReasonConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discountreasonconfigs/{id}")
  public XfR patchUpdate(@RequestBody DiscountReasonConfig discountReasonConfig,@PathVariable Long id) {
      DiscountReasonConfig updiscountReasonConfig = discountReasonConfigServiceImpl.getById(id);
      if(updiscountReasonConfig != null){
        updiscountReasonConfig = ObjectCopyUtils.copyProperties(discountReasonConfig,updiscountReasonConfig,true);
      }
      return XfR.ok(discountReasonConfigServiceImpl.updateById(updiscountReasonConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discountreasonconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discountReasonConfigServiceImpl.removeById(id));
  }

  @PostMapping("/discountreasonconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discount_reason_config");
     params.put("request", condition);

     return XfR.ok(discountReasonConfigServiceImpl.querys(params));
  }

}
