package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.FileProcessLog;
import com.xforceplus.jcunilever.service.IFileProcessLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-19
 */
@RestController
public class FileProcessLogController {

  @Autowired
  private IFileProcessLogService fileProcessLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fileProcessLog ${table.comment}
   * @return
   */
  @GetMapping("/fileprocesslogs" )
  public XfR getFileProcessLogs(XfPage page, FileProcessLog fileProcessLog) {
    return XfR.ok(fileProcessLogServiceImpl.page(page, Wrappers.query(fileProcessLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fileprocesslogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fileProcessLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fileProcessLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/fileprocesslogs")
  public XfR save(@RequestBody FileProcessLog fileProcessLog) {
     return XfR.ok(fileProcessLogServiceImpl.save(fileProcessLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fileProcessLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/fileprocesslogs/{id}")
  public XfR putUpdate(@RequestBody FileProcessLog fileProcessLog,@PathVariable Long id) {
      fileProcessLog.setId(id);
      return XfR.ok(fileProcessLogServiceImpl.updateById(fileProcessLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fileProcessLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fileprocesslogs/{id}")
  public XfR patchUpdate(@RequestBody FileProcessLog fileProcessLog,@PathVariable Long id) {
      FileProcessLog upfileProcessLog = fileProcessLogServiceImpl.getById(id);
      if(upfileProcessLog != null){
        upfileProcessLog = ObjectCopyUtils.copyProperties(fileProcessLog,upfileProcessLog,true);
      }
      return XfR.ok(fileProcessLogServiceImpl.updateById(upfileProcessLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fileprocesslogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fileProcessLogServiceImpl.removeById(id));
  }

  @PostMapping("/fileprocesslogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "file_process_log");
     params.put("request", condition);

     return XfR.ok(fileProcessLogServiceImpl.querys(params));
  }

}
