package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.NoInvoiceNotesConfig;
import com.xforceplus.jcunilever.service.INoInvoiceNotesConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-19
 */
@RestController
public class NoInvoiceNotesConfigController {

  @Autowired
  private INoInvoiceNotesConfigService noInvoiceNotesConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noInvoiceNotesConfig ${table.comment}
   * @return
   */
  @GetMapping("/noinvoicenotesconfigs" )
  public XfR getNoInvoiceNotesConfigs(XfPage page, NoInvoiceNotesConfig noInvoiceNotesConfig) {
    return XfR.ok(noInvoiceNotesConfigServiceImpl.page(page, Wrappers.query(noInvoiceNotesConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/noinvoicenotesconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noInvoiceNotesConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param noInvoiceNotesConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/noinvoicenotesconfigs")
  public XfR save(@RequestBody NoInvoiceNotesConfig noInvoiceNotesConfig) {
     return XfR.ok(noInvoiceNotesConfigServiceImpl.save(noInvoiceNotesConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param noInvoiceNotesConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/noinvoicenotesconfigs/{id}")
  public XfR putUpdate(@RequestBody NoInvoiceNotesConfig noInvoiceNotesConfig,@PathVariable Long id) {
      noInvoiceNotesConfig.setId(id);
      return XfR.ok(noInvoiceNotesConfigServiceImpl.updateById(noInvoiceNotesConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param noInvoiceNotesConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/noinvoicenotesconfigs/{id}")
  public XfR patchUpdate(@RequestBody NoInvoiceNotesConfig noInvoiceNotesConfig,@PathVariable Long id) {
      NoInvoiceNotesConfig upnoInvoiceNotesConfig = noInvoiceNotesConfigServiceImpl.getById(id);
      if(upnoInvoiceNotesConfig != null){
        upnoInvoiceNotesConfig = ObjectCopyUtils.copyProperties(noInvoiceNotesConfig,upnoInvoiceNotesConfig,true);
      }
      return XfR.ok(noInvoiceNotesConfigServiceImpl.updateById(upnoInvoiceNotesConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noinvoicenotesconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noInvoiceNotesConfigServiceImpl.removeById(id));
  }

  @PostMapping("/noinvoicenotesconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_invoice_notes_config");
     params.put("request", condition);

     return XfR.ok(noInvoiceNotesConfigServiceImpl.querys(params));
  }

}
