package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.OpenARHead;
import com.xforceplus.jcunilever.service.IOpenARHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-19
 */
@RestController
public class OpenARHeadController {

  @Autowired
  private IOpenARHeadService openARHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param openARHead ${table.comment}
   * @return
   */
  @GetMapping("/openarheads" )
  public XfR getOpenARHeads(XfPage page, OpenARHead openARHead) {
    return XfR.ok(openARHeadServiceImpl.page(page, Wrappers.query(openARHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/openarheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(openARHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param openARHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/openarheads")
  public XfR save(@RequestBody OpenARHead openARHead) {
     return XfR.ok(openARHeadServiceImpl.save(openARHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param openARHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/openarheads/{id}")
  public XfR putUpdate(@RequestBody OpenARHead openARHead,@PathVariable Long id) {
      openARHead.setId(id);
      return XfR.ok(openARHeadServiceImpl.updateById(openARHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param openARHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/openarheads/{id}")
  public XfR patchUpdate(@RequestBody OpenARHead openARHead,@PathVariable Long id) {
      OpenARHead upopenARHead = openARHeadServiceImpl.getById(id);
      if(upopenARHead != null){
        upopenARHead = ObjectCopyUtils.copyProperties(openARHead,upopenARHead,true);
      }
      return XfR.ok(openARHeadServiceImpl.updateById(upopenARHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/openarheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(openARHeadServiceImpl.removeById(id));
  }

  @PostMapping("/openarheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "open_a_r_head");
     params.put("request", condition);

     return XfR.ok(openARHeadServiceImpl.querys(params));
  }

}
