package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.MdmSync;
import com.xforceplus.jcunilever.service.IMdmSyncService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class MdmSyncController {

  @Autowired
  private IMdmSyncService mdmSyncServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdmSync OTC业务
   * @return
   */
  @GetMapping("/mdmsyncs" )
  public XfR getMdmSyncs(XfPage page, MdmSync mdmSync) {
    return XfR.ok(mdmSyncServiceImpl.page(page, Wrappers.query(mdmSync)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdmsyncs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmSyncServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param mdmSync OTC业务
   * @return XfR
   */
  @PostMapping("/mdmsyncs")
  public XfR save(@RequestBody MdmSync mdmSync) {
     return XfR.ok(mdmSyncServiceImpl.save(mdmSync));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param mdmSync OTC业务
   * @return XfR
   */
  @PutMapping("/mdmsyncs/{id}")
  public XfR putUpdate(@RequestBody MdmSync mdmSync,@PathVariable Long id) {
      mdmSync.setId(id);
      return XfR.ok(mdmSyncServiceImpl.updateById(mdmSync));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param mdmSync OTC业务
   * @return XfR
   */
  @PatchMapping("/mdmsyncs/{id}")
  public XfR patchUpdate(@RequestBody MdmSync mdmSync,@PathVariable Long id) {
      MdmSync upmdmSync = mdmSyncServiceImpl.getById(id);
      if(upmdmSync != null){
        upmdmSync = ObjectCopyUtils.copyProperties(mdmSync,upmdmSync,true);
      }
      return XfR.ok(mdmSyncServiceImpl.updateById(upmdmSync));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdmsyncs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmSyncServiceImpl.removeById(id));
  }

  @PostMapping("/mdmsyncs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm_sync");
     params.put("request", condition);

     return XfR.ok(mdmSyncServiceImpl.querys(params));
  }

}
