package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.NoInvoiceExceedAmountConfig;
import com.xforceplus.jcunilever.service.INoInvoiceExceedAmountConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class NoInvoiceExceedAmountConfigController {

  @Autowired
  private INoInvoiceExceedAmountConfigService noInvoiceExceedAmountConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noInvoiceExceedAmountConfig OTC业务
   * @return
   */
  @GetMapping("/noinvoiceexceedamountconfigs" )
  public XfR getNoInvoiceExceedAmountConfigs(XfPage page, NoInvoiceExceedAmountConfig noInvoiceExceedAmountConfig) {
    return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.page(page, Wrappers.query(noInvoiceExceedAmountConfig)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/noinvoiceexceedamountconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param noInvoiceExceedAmountConfig OTC业务
   * @return XfR
   */
  @PostMapping("/noinvoiceexceedamountconfigs")
  public XfR save(@RequestBody NoInvoiceExceedAmountConfig noInvoiceExceedAmountConfig) {
     return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.save(noInvoiceExceedAmountConfig));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param noInvoiceExceedAmountConfig OTC业务
   * @return XfR
   */
  @PutMapping("/noinvoiceexceedamountconfigs/{id}")
  public XfR putUpdate(@RequestBody NoInvoiceExceedAmountConfig noInvoiceExceedAmountConfig,@PathVariable Long id) {
      noInvoiceExceedAmountConfig.setId(id);
      return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.updateById(noInvoiceExceedAmountConfig));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param noInvoiceExceedAmountConfig OTC业务
   * @return XfR
   */
  @PatchMapping("/noinvoiceexceedamountconfigs/{id}")
  public XfR patchUpdate(@RequestBody NoInvoiceExceedAmountConfig noInvoiceExceedAmountConfig,@PathVariable Long id) {
      NoInvoiceExceedAmountConfig upnoInvoiceExceedAmountConfig = noInvoiceExceedAmountConfigServiceImpl.getById(id);
      if(upnoInvoiceExceedAmountConfig != null){
        upnoInvoiceExceedAmountConfig = ObjectCopyUtils.copyProperties(noInvoiceExceedAmountConfig,upnoInvoiceExceedAmountConfig,true);
      }
      return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.updateById(upnoInvoiceExceedAmountConfig));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noinvoiceexceedamountconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.removeById(id));
  }

  @PostMapping("/noinvoiceexceedamountconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_invoice_exceed_amount_config");
     params.put("request", condition);

     return XfR.ok(noInvoiceExceedAmountConfigServiceImpl.querys(params));
  }

}
