package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.RedLetterNumberAndCcmsApplyNo;
import com.xforceplus.jcunilever.service.IRedLetterNumberAndCcmsApplyNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class RedLetterNumberAndCcmsApplyNoController {

  @Autowired
  private IRedLetterNumberAndCcmsApplyNoService redLetterNumberAndCcmsApplyNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterNumberAndCcmsApplyNo ${table.comment}
   * @return
   */
  @GetMapping("/redletternumberandccmsapplynos" )
  public XfR getRedLetterNumberAndCcmsApplyNos(XfPage page, RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo) {
    return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.page(page, Wrappers.query(redLetterNumberAndCcmsApplyNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletternumberandccmsapplynos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterNumberAndCcmsApplyNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletternumberandccmsapplynos")
  public XfR save(@RequestBody RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo) {
     return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.save(redLetterNumberAndCcmsApplyNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterNumberAndCcmsApplyNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletternumberandccmsapplynos/{id}")
  public XfR putUpdate(@RequestBody RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo,@PathVariable Long id) {
      redLetterNumberAndCcmsApplyNo.setId(id);
      return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.updateById(redLetterNumberAndCcmsApplyNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterNumberAndCcmsApplyNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletternumberandccmsapplynos/{id}")
  public XfR patchUpdate(@RequestBody RedLetterNumberAndCcmsApplyNo redLetterNumberAndCcmsApplyNo,@PathVariable Long id) {
      RedLetterNumberAndCcmsApplyNo upredLetterNumberAndCcmsApplyNo = redLetterNumberAndCcmsApplyNoServiceImpl.getById(id);
      if(upredLetterNumberAndCcmsApplyNo != null){
        upredLetterNumberAndCcmsApplyNo = ObjectCopyUtils.copyProperties(redLetterNumberAndCcmsApplyNo,upredLetterNumberAndCcmsApplyNo,true);
      }
      return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.updateById(upredLetterNumberAndCcmsApplyNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletternumberandccmsapplynos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.removeById(id));
  }

  @PostMapping("/redletternumberandccmsapplynos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_number_and_ccms_apply_no");
     params.put("request", condition);

     return XfR.ok(redLetterNumberAndCcmsApplyNoServiceImpl.querys(params));
  }

}
