package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.InvoiceDetail;
import com.xforceplus.jcunilever.service.IInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-09
 */
@RestController
public class InvoiceDetailController {

  @Autowired
  private IInvoiceDetailService invoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDetail OTC业务
   * @return
   */
  @GetMapping("/invoicedetails" )
  public XfR getInvoiceDetails(XfPage page, InvoiceDetail invoiceDetail) {
    return XfR.ok(invoiceDetailServiceImpl.page(page, Wrappers.query(invoiceDetail)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param invoiceDetail OTC业务
   * @return XfR
   */
  @PostMapping("/invoicedetails")
  public XfR save(@RequestBody InvoiceDetail invoiceDetail) {
     return XfR.ok(invoiceDetailServiceImpl.save(invoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param invoiceDetail OTC业务
   * @return XfR
   */
  @PutMapping("/invoicedetails/{id}")
  public XfR putUpdate(@RequestBody InvoiceDetail invoiceDetail,@PathVariable Long id) {
      invoiceDetail.setId(id);
      return XfR.ok(invoiceDetailServiceImpl.updateById(invoiceDetail));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param invoiceDetail OTC业务
   * @return XfR
   */
  @PatchMapping("/invoicedetails/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDetail invoiceDetail,@PathVariable Long id) {
      InvoiceDetail upinvoiceDetail = invoiceDetailServiceImpl.getById(id);
      if(upinvoiceDetail != null){
        upinvoiceDetail = ObjectCopyUtils.copyProperties(invoiceDetail,upinvoiceDetail,true);
      }
      return XfR.ok(invoiceDetailServiceImpl.updateById(upinvoiceDetail));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_detail");
     params.put("request", condition);

     return XfR.ok(invoiceDetailServiceImpl.querys(params));
  }

}
