package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.MdmInit;
import com.xforceplus.jcunilever.service.IMdmInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-09
 */
@RestController
public class MdmInitController {

  @Autowired
  private IMdmInitService mdmInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdmInit OTC业务
   * @return
   */
  @GetMapping("/mdminits" )
  public XfR getMdmInits(XfPage page, MdmInit mdmInit) {
    return XfR.ok(mdmInitServiceImpl.page(page, Wrappers.query(mdmInit)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdminits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmInitServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param mdmInit OTC业务
   * @return XfR
   */
  @PostMapping("/mdminits")
  public XfR save(@RequestBody MdmInit mdmInit) {
     return XfR.ok(mdmInitServiceImpl.save(mdmInit));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param mdmInit OTC业务
   * @return XfR
   */
  @PutMapping("/mdminits/{id}")
  public XfR putUpdate(@RequestBody MdmInit mdmInit,@PathVariable Long id) {
      mdmInit.setId(id);
      return XfR.ok(mdmInitServiceImpl.updateById(mdmInit));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param mdmInit OTC业务
   * @return XfR
   */
  @PatchMapping("/mdminits/{id}")
  public XfR patchUpdate(@RequestBody MdmInit mdmInit,@PathVariable Long id) {
      MdmInit upmdmInit = mdmInitServiceImpl.getById(id);
      if(upmdmInit != null){
        upmdmInit = ObjectCopyUtils.copyProperties(mdmInit,upmdmInit,true);
      }
      return XfR.ok(mdmInitServiceImpl.updateById(upmdmInit));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdminits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmInitServiceImpl.removeById(id));
  }

  @PostMapping("/mdminits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm_init");
     params.put("request", condition);

     return XfR.ok(mdmInitServiceImpl.querys(params));
  }

}
