package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.OrderPoolSync;
import com.xforceplus.jcunilever.service.IOrderPoolSyncService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-09
 */
@RestController
public class OrderPoolSyncController {

  @Autowired
  private IOrderPoolSyncService orderPoolSyncServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderPoolSync ${table.comment}
   * @return
   */
  @GetMapping("/orderpoolsyncs" )
  public XfR getOrderPoolSyncs(XfPage page, OrderPoolSync orderPoolSync) {
    return XfR.ok(orderPoolSyncServiceImpl.page(page, Wrappers.query(orderPoolSync)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderpoolsyncs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderPoolSyncServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderPoolSync ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderpoolsyncs")
  public XfR save(@RequestBody OrderPoolSync orderPoolSync) {
     return XfR.ok(orderPoolSyncServiceImpl.save(orderPoolSync));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderPoolSync ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderpoolsyncs/{id}")
  public XfR putUpdate(@RequestBody OrderPoolSync orderPoolSync,@PathVariable Long id) {
      orderPoolSync.setId(id);
      return XfR.ok(orderPoolSyncServiceImpl.updateById(orderPoolSync));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderPoolSync ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderpoolsyncs/{id}")
  public XfR patchUpdate(@RequestBody OrderPoolSync orderPoolSync,@PathVariable Long id) {
      OrderPoolSync uporderPoolSync = orderPoolSyncServiceImpl.getById(id);
      if(uporderPoolSync != null){
        uporderPoolSync = ObjectCopyUtils.copyProperties(orderPoolSync,uporderPoolSync,true);
      }
      return XfR.ok(orderPoolSyncServiceImpl.updateById(uporderPoolSync));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderpoolsyncs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderPoolSyncServiceImpl.removeById(id));
  }

  @PostMapping("/orderpoolsyncs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_pool_sync");
     params.put("request", condition);

     return XfR.ok(orderPoolSyncServiceImpl.querys(params));
  }

}
