package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.SettlementPool;
import com.xforceplus.jcunilever.service.ISettlementPoolService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * DTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-09
 */
@RestController
public class SettlementPoolController {

  @Autowired
  private ISettlementPoolService settlementPoolServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementPool DTC业务
   * @return
   */
  @GetMapping("/settlementpools" )
  public XfR getSettlementPools(XfPage page, SettlementPool settlementPool) {
    return XfR.ok(settlementPoolServiceImpl.page(page, Wrappers.query(settlementPool)));
  }

  /**
   * 通过id查询DTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementpools/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementPoolServiceImpl.getById(id));
  }

  /**
   * 新增DTC业务
   * @param settlementPool DTC业务
   * @return XfR
   */
  @PostMapping("/settlementpools")
  public XfR save(@RequestBody SettlementPool settlementPool) {
     return XfR.ok(settlementPoolServiceImpl.save(settlementPool));
  }

  /**
   * 修改-传入修改后的全部数据DTC业务
   * @param settlementPool DTC业务
   * @return XfR
   */
  @PutMapping("/settlementpools/{id}")
  public XfR putUpdate(@RequestBody SettlementPool settlementPool,@PathVariable Long id) {
      settlementPool.setId(id);
      return XfR.ok(settlementPoolServiceImpl.updateById(settlementPool));
  }

  /**
   * 修改-传入修改的数据DTC业务
   * @param settlementPool DTC业务
   * @return XfR
   */
  @PatchMapping("/settlementpools/{id}")
  public XfR patchUpdate(@RequestBody SettlementPool settlementPool,@PathVariable Long id) {
      SettlementPool upsettlementPool = settlementPoolServiceImpl.getById(id);
      if(upsettlementPool != null){
        upsettlementPool = ObjectCopyUtils.copyProperties(settlementPool,upsettlementPool,true);
      }
      return XfR.ok(settlementPoolServiceImpl.updateById(upsettlementPool));
  }

  /**
   * 通过id删除DTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementpools/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementPoolServiceImpl.removeById(id));
  }

  @PostMapping("/settlementpools/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_pool");
     params.put("request", condition);

     return XfR.ok(settlementPoolServiceImpl.querys(params));
  }

}
