package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.InvoiceMergeNoRelation;
import com.xforceplus.jcunilever.service.IInvoiceMergeNoRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class InvoiceMergeNoRelationController {

  @Autowired
  private IInvoiceMergeNoRelationService invoiceMergeNoRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMergeNoRelation OTC业务
   * @return
   */
  @GetMapping("/invoicemergenorelations" )
  public XfR getInvoiceMergeNoRelations(XfPage page, InvoiceMergeNoRelation invoiceMergeNoRelation) {
    return XfR.ok(invoiceMergeNoRelationServiceImpl.page(page, Wrappers.query(invoiceMergeNoRelation)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemergenorelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMergeNoRelationServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param invoiceMergeNoRelation OTC业务
   * @return XfR
   */
  @PostMapping("/invoicemergenorelations")
  public XfR save(@RequestBody InvoiceMergeNoRelation invoiceMergeNoRelation) {
     return XfR.ok(invoiceMergeNoRelationServiceImpl.save(invoiceMergeNoRelation));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param invoiceMergeNoRelation OTC业务
   * @return XfR
   */
  @PutMapping("/invoicemergenorelations/{id}")
  public XfR putUpdate(@RequestBody InvoiceMergeNoRelation invoiceMergeNoRelation,@PathVariable Long id) {
      invoiceMergeNoRelation.setId(id);
      return XfR.ok(invoiceMergeNoRelationServiceImpl.updateById(invoiceMergeNoRelation));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param invoiceMergeNoRelation OTC业务
   * @return XfR
   */
  @PatchMapping("/invoicemergenorelations/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMergeNoRelation invoiceMergeNoRelation,@PathVariable Long id) {
      InvoiceMergeNoRelation upinvoiceMergeNoRelation = invoiceMergeNoRelationServiceImpl.getById(id);
      if(upinvoiceMergeNoRelation != null){
        upinvoiceMergeNoRelation = ObjectCopyUtils.copyProperties(invoiceMergeNoRelation,upinvoiceMergeNoRelation,true);
      }
      return XfR.ok(invoiceMergeNoRelationServiceImpl.updateById(upinvoiceMergeNoRelation));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemergenorelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMergeNoRelationServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemergenorelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_merge_no_relation");
     params.put("request", condition);

     return XfR.ok(invoiceMergeNoRelationServiceImpl.querys(params));
  }

}
