package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.Kok5;
import com.xforceplus.jcunilever.service.IKok5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class Kok5Controller {

  @Autowired
  private IKok5Service kok5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param kok5 ${table.comment}
   * @return
   */
  @GetMapping("/kok5s" )
  public XfR getKok5s(XfPage page, Kok5 kok5) {
    return XfR.ok(kok5ServiceImpl.page(page, Wrappers.query(kok5)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/kok5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(kok5ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param kok5 ${table.comment}
   * @return XfR
   */
  @PostMapping("/kok5s")
  public XfR save(@RequestBody Kok5 kok5) {
     return XfR.ok(kok5ServiceImpl.save(kok5));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param kok5 ${table.comment}
   * @return XfR
   */
  @PutMapping("/kok5s/{id}")
  public XfR putUpdate(@RequestBody Kok5 kok5,@PathVariable Long id) {
      kok5.setId(id);
      return XfR.ok(kok5ServiceImpl.updateById(kok5));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param kok5 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/kok5s/{id}")
  public XfR patchUpdate(@RequestBody Kok5 kok5,@PathVariable Long id) {
      Kok5 upkok5 = kok5ServiceImpl.getById(id);
      if(upkok5 != null){
        upkok5 = ObjectCopyUtils.copyProperties(kok5,upkok5,true);
      }
      return XfR.ok(kok5ServiceImpl.updateById(upkok5));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/kok5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(kok5ServiceImpl.removeById(id));
  }

  @PostMapping("/kok5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "kok5");
     params.put("request", condition);

     return XfR.ok(kok5ServiceImpl.querys(params));
  }

}
