package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.MdmCustomerGroup;
import com.xforceplus.jcunilever.service.IMdmCustomerGroupService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class MdmCustomerGroupController {

  @Autowired
  private IMdmCustomerGroupService mdmCustomerGroupServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdmCustomerGroup OTC业务
   * @return
   */
  @GetMapping("/mdmcustomergroups" )
  public XfR getMdmCustomerGroups(XfPage page, MdmCustomerGroup mdmCustomerGroup) {
    return XfR.ok(mdmCustomerGroupServiceImpl.page(page, Wrappers.query(mdmCustomerGroup)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdmcustomergroups/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmCustomerGroupServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param mdmCustomerGroup OTC业务
   * @return XfR
   */
  @PostMapping("/mdmcustomergroups")
  public XfR save(@RequestBody MdmCustomerGroup mdmCustomerGroup) {
     return XfR.ok(mdmCustomerGroupServiceImpl.save(mdmCustomerGroup));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param mdmCustomerGroup OTC业务
   * @return XfR
   */
  @PutMapping("/mdmcustomergroups/{id}")
  public XfR putUpdate(@RequestBody MdmCustomerGroup mdmCustomerGroup,@PathVariable Long id) {
      mdmCustomerGroup.setId(id);
      return XfR.ok(mdmCustomerGroupServiceImpl.updateById(mdmCustomerGroup));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param mdmCustomerGroup OTC业务
   * @return XfR
   */
  @PatchMapping("/mdmcustomergroups/{id}")
  public XfR patchUpdate(@RequestBody MdmCustomerGroup mdmCustomerGroup,@PathVariable Long id) {
      MdmCustomerGroup upmdmCustomerGroup = mdmCustomerGroupServiceImpl.getById(id);
      if(upmdmCustomerGroup != null){
        upmdmCustomerGroup = ObjectCopyUtils.copyProperties(mdmCustomerGroup,upmdmCustomerGroup,true);
      }
      return XfR.ok(mdmCustomerGroupServiceImpl.updateById(upmdmCustomerGroup));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdmcustomergroups/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmCustomerGroupServiceImpl.removeById(id));
  }

  @PostMapping("/mdmcustomergroups/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm_customer_group");
     params.put("request", condition);

     return XfR.ok(mdmCustomerGroupServiceImpl.querys(params));
  }

}
