package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.NoInvoiceBillingTypeConfig;
import com.xforceplus.jcunilever.service.INoInvoiceBillingTypeConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class NoInvoiceBillingTypeConfigController {

  @Autowired
  private INoInvoiceBillingTypeConfigService noInvoiceBillingTypeConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noInvoiceBillingTypeConfig OTC业务
   * @return
   */
  @GetMapping("/noinvoicebillingtypeconfigs" )
  public XfR getNoInvoiceBillingTypeConfigs(XfPage page, NoInvoiceBillingTypeConfig noInvoiceBillingTypeConfig) {
    return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.page(page, Wrappers.query(noInvoiceBillingTypeConfig)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/noinvoicebillingtypeconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param noInvoiceBillingTypeConfig OTC业务
   * @return XfR
   */
  @PostMapping("/noinvoicebillingtypeconfigs")
  public XfR save(@RequestBody NoInvoiceBillingTypeConfig noInvoiceBillingTypeConfig) {
     return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.save(noInvoiceBillingTypeConfig));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param noInvoiceBillingTypeConfig OTC业务
   * @return XfR
   */
  @PutMapping("/noinvoicebillingtypeconfigs/{id}")
  public XfR putUpdate(@RequestBody NoInvoiceBillingTypeConfig noInvoiceBillingTypeConfig,@PathVariable Long id) {
      noInvoiceBillingTypeConfig.setId(id);
      return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.updateById(noInvoiceBillingTypeConfig));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param noInvoiceBillingTypeConfig OTC业务
   * @return XfR
   */
  @PatchMapping("/noinvoicebillingtypeconfigs/{id}")
  public XfR patchUpdate(@RequestBody NoInvoiceBillingTypeConfig noInvoiceBillingTypeConfig,@PathVariable Long id) {
      NoInvoiceBillingTypeConfig upnoInvoiceBillingTypeConfig = noInvoiceBillingTypeConfigServiceImpl.getById(id);
      if(upnoInvoiceBillingTypeConfig != null){
        upnoInvoiceBillingTypeConfig = ObjectCopyUtils.copyProperties(noInvoiceBillingTypeConfig,upnoInvoiceBillingTypeConfig,true);
      }
      return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.updateById(upnoInvoiceBillingTypeConfig));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noinvoicebillingtypeconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.removeById(id));
  }

  @PostMapping("/noinvoicebillingtypeconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_invoice_billing_type_config");
     params.put("request", condition);

     return XfR.ok(noInvoiceBillingTypeConfigServiceImpl.querys(params));
  }

}
