package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.OrderPoolRaw;
import com.xforceplus.jcunilever.service.IOrderPoolRawService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * DTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class OrderPoolRawController {

  @Autowired
  private IOrderPoolRawService orderPoolRawServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderPoolRaw DTC业务
   * @return
   */
  @GetMapping("/orderpoolraws" )
  public XfR getOrderPoolRaws(XfPage page, OrderPoolRaw orderPoolRaw) {
    return XfR.ok(orderPoolRawServiceImpl.page(page, Wrappers.query(orderPoolRaw)));
  }

  /**
   * 通过id查询DTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderpoolraws/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderPoolRawServiceImpl.getById(id));
  }

  /**
   * 新增DTC业务
   * @param orderPoolRaw DTC业务
   * @return XfR
   */
  @PostMapping("/orderpoolraws")
  public XfR save(@RequestBody OrderPoolRaw orderPoolRaw) {
     return XfR.ok(orderPoolRawServiceImpl.save(orderPoolRaw));
  }

  /**
   * 修改-传入修改后的全部数据DTC业务
   * @param orderPoolRaw DTC业务
   * @return XfR
   */
  @PutMapping("/orderpoolraws/{id}")
  public XfR putUpdate(@RequestBody OrderPoolRaw orderPoolRaw,@PathVariable Long id) {
      orderPoolRaw.setId(id);
      return XfR.ok(orderPoolRawServiceImpl.updateById(orderPoolRaw));
  }

  /**
   * 修改-传入修改的数据DTC业务
   * @param orderPoolRaw DTC业务
   * @return XfR
   */
  @PatchMapping("/orderpoolraws/{id}")
  public XfR patchUpdate(@RequestBody OrderPoolRaw orderPoolRaw,@PathVariable Long id) {
      OrderPoolRaw uporderPoolRaw = orderPoolRawServiceImpl.getById(id);
      if(uporderPoolRaw != null){
        uporderPoolRaw = ObjectCopyUtils.copyProperties(orderPoolRaw,uporderPoolRaw,true);
      }
      return XfR.ok(orderPoolRawServiceImpl.updateById(uporderPoolRaw));
  }

  /**
   * 通过id删除DTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderpoolraws/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderPoolRawServiceImpl.removeById(id));
  }

  @PostMapping("/orderpoolraws/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_pool_raw");
     params.put("request", condition);

     return XfR.ok(orderPoolRawServiceImpl.querys(params));
  }

}
