package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.SettlementPoolSync;
import com.xforceplus.jcunilever.service.ISettlementPoolSyncService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class SettlementPoolSyncController {

  @Autowired
  private ISettlementPoolSyncService settlementPoolSyncServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementPoolSync ${table.comment}
   * @return
   */
  @GetMapping("/settlementpoolsyncs" )
  public XfR getSettlementPoolSyncs(XfPage page, SettlementPoolSync settlementPoolSync) {
    return XfR.ok(settlementPoolSyncServiceImpl.page(page, Wrappers.query(settlementPoolSync)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementpoolsyncs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementPoolSyncServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementPoolSync ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementpoolsyncs")
  public XfR save(@RequestBody SettlementPoolSync settlementPoolSync) {
     return XfR.ok(settlementPoolSyncServiceImpl.save(settlementPoolSync));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementPoolSync ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementpoolsyncs/{id}")
  public XfR putUpdate(@RequestBody SettlementPoolSync settlementPoolSync,@PathVariable Long id) {
      settlementPoolSync.setId(id);
      return XfR.ok(settlementPoolSyncServiceImpl.updateById(settlementPoolSync));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementPoolSync ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementpoolsyncs/{id}")
  public XfR patchUpdate(@RequestBody SettlementPoolSync settlementPoolSync,@PathVariable Long id) {
      SettlementPoolSync upsettlementPoolSync = settlementPoolSyncServiceImpl.getById(id);
      if(upsettlementPoolSync != null){
        upsettlementPoolSync = ObjectCopyUtils.copyProperties(settlementPoolSync,upsettlementPoolSync,true);
      }
      return XfR.ok(settlementPoolSyncServiceImpl.updateById(upsettlementPoolSync));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementpoolsyncs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementPoolSyncServiceImpl.removeById(id));
  }

  @PostMapping("/settlementpoolsyncs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_pool_sync");
     params.put("request", condition);

     return XfR.ok(settlementPoolSyncServiceImpl.querys(params));
  }

}
