package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.Statement;
import com.xforceplus.jcunilever.service.IStatementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OTC业务前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class StatementController {

  @Autowired
  private IStatementService statementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statement OTC业务
   * @return
   */
  @GetMapping("/statements" )
  public XfR getStatements(XfPage page, Statement statement) {
    return XfR.ok(statementServiceImpl.page(page, Wrappers.query(statement)));
  }

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return XfR
   */
  @GetMapping("/statements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statementServiceImpl.getById(id));
  }

  /**
   * 新增OTC业务
   * @param statement OTC业务
   * @return XfR
   */
  @PostMapping("/statements")
  public XfR save(@RequestBody Statement statement) {
     return XfR.ok(statementServiceImpl.save(statement));
  }

  /**
   * 修改-传入修改后的全部数据OTC业务
   * @param statement OTC业务
   * @return XfR
   */
  @PutMapping("/statements/{id}")
  public XfR putUpdate(@RequestBody Statement statement,@PathVariable Long id) {
      statement.setId(id);
      return XfR.ok(statementServiceImpl.updateById(statement));
  }

  /**
   * 修改-传入修改的数据OTC业务
   * @param statement OTC业务
   * @return XfR
   */
  @PatchMapping("/statements/{id}")
  public XfR patchUpdate(@RequestBody Statement statement,@PathVariable Long id) {
      Statement upstatement = statementServiceImpl.getById(id);
      if(upstatement != null){
        upstatement = ObjectCopyUtils.copyProperties(statement,upstatement,true);
      }
      return XfR.ok(statementServiceImpl.updateById(upstatement));
  }

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statementServiceImpl.removeById(id));
  }

  @PostMapping("/statements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statement");
     params.put("request", condition);

     return XfR.ok(statementServiceImpl.querys(params));
  }

}
